/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view;

import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import java.awt.image.BufferedImage;
import java.io.Serializable;

public class SkaterCharacter
implements Serializable {
    private final String imageResourceName;
    private final String name;
    private final double mass;
    private final double modelHeight;
    private final double heightDivisor;

    public SkaterCharacter(String string, String string2, double d, double d2) {
        this(string, string2, d, d2, 1.0);
    }

    public SkaterCharacter(String string, String string2, double d, double d2, double d3) {
        this.imageResourceName = string;
        this.name = string2;
        this.mass = d;
        this.modelHeight = d2;
        this.heightDivisor = d3;
    }

    public boolean equals(Object object) {
        if (object instanceof SkaterCharacter) {
            SkaterCharacter skaterCharacter = (SkaterCharacter)object;
            return skaterCharacter.imageResourceName.equals(this.imageResourceName) && skaterCharacter.name.equals(this.name) && skaterCharacter.mass == this.mass && skaterCharacter.modelHeight == this.modelHeight && skaterCharacter.heightDivisor == this.heightDivisor;
        }
        return false;
    }

    public double getModelWidth() {
        return this.modelHeight / (double)this.getImage().getHeight() * (double)this.getImage().getWidth();
    }

    public double getModelHeight() {
        return this.modelHeight;
    }

    public String getName() {
        return this.name;
    }

    public double getMass() {
        return this.mass;
    }

    public String getImageResourceName() {
        return this.imageResourceName;
    }

    public BufferedImage getImage() {
        return EnergySkateParkResources.getImage(this.getImageResourceName());
    }

    public double getHeightDivisor() {
        return this.heightDivisor;
    }
}

