/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view;

import edu.colorado.phet.common.piccolophet.help.MotionHelpBalloon;
import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.view.piccolo.EnergySkateParkRootNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;

public class WiggleMeInSpace {
    private final AbstractEnergySkateParkModule module;
    private final MotionHelpBalloon hintNode;
    private boolean hintDone = false;

    public WiggleMeInSpace(final AbstractEnergySkateParkModule abstractEnergySkateParkModule) {
        this.module = abstractEnergySkateParkModule;
        this.hintNode = new MotionHelpBalloon(abstractEnergySkateParkModule.getDefaultHelpPane(), EnergySkateParkResources.getString("invitaiton.arrow-keys"));
        this.hintNode.setTextColor(Color.white);
        this.hintNode.setShadowTextColor(Color.darkGray);
        this.hintNode.setShadowTextOffset(1.0);
        abstractEnergySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void gravityChanged() {
                if (abstractEnergySkateParkModule.getEnergySkateParkModel().getGravity() == 0.0 && !WiggleMeInSpace.this.hintDone) {
                    WiggleMeInSpace.this.startHint();
                } else {
                    WiggleMeInSpace.this.closeHint();
                }
            }
        });
        this.hintNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                super.mousePressed(pInputEvent);
                WiggleMeInSpace.this.hintNode.setVisible(false);
            }
        });
    }

    private void closeHint() {
        this.getRootNode().removeScreenChild(this.hintNode);
    }

    private void startHint() {
        this.module.getEnergySkateParkSimulationPanel().requestFocus();
        this.getRootNode().addScreenChild(this.hintNode);
        this.hintNode.setOffset(this.module.getEnergySkateParkSimulationPanel().getWidth() / 2, this.hintNode.getFullBounds().getHeight() / 2.0);
        this.hintNode.animateTo(this.module.getEnergySkateParkSimulationPanel().getWidth() / 2, (int)((double)this.module.getEnergySkateParkSimulationPanel().getHeight() * 1.0 / 4.0));
        this.module.getEnergySkateParkModel().getBody(0).addListener(new Body.ListenerAdapter(){

            public void thrustChanged() {
                if (WiggleMeInSpace.this.module.getEnergySkateParkModel().getBody(0).getThrust().getMagnitude() > 0.0) {
                    WiggleMeInSpace.this.hintNode.setVisible(false);
                    WiggleMeInSpace.this.hintDone = true;
                }
            }
        });
    }

    private EnergySkateParkRootNode getRootNode() {
        return this.module.getEnergySkateParkSimulationPanel().getRootNode();
    }

    public void start() {
    }
}

