/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;
import edu.colorado.phet.energyskatepark.view.piccolo.EnergySkateParkRootNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class BackgroundScreenNode
extends PhetPNode {
    private final EnergySkateParkSimulationPanel canvas;
    private BufferedImage backgroundImage;
    private final PNode floorGraphic;

    public BackgroundScreenNode(EnergySkateParkSimulationPanel energySkateParkSimulationPanel, BufferedImage bufferedImage, PNode pNode) {
        this.canvas = energySkateParkSimulationPanel;
        this.backgroundImage = bufferedImage;
        this.floorGraphic = pNode;
        pNode.addPropertyChangeListener("visible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BackgroundScreenNode.this.update();
            }
        });
        energySkateParkSimulationPanel.addListener(new EnergySkateParkSimulationPanel.Adapter(){

            public void zoomChanged() {
                BackgroundScreenNode.this.update();
            }
        });
    }

    public void update() {
        this.removeAllChildren();
        if (this.backgroundImage != null) {
            BufferedImage bufferedImage = this.backgroundImage;
            double d = (double)this.canvas.getHeight() / (double)bufferedImage.getHeight();
            double d2 = (double)this.canvas.getWidth() / (double)bufferedImage.getWidth();
            if (this.canvas.getHeight() > 0 && this.canvas.getWidth() > 0) {
                bufferedImage = d2 > d ? BufferedImageUtils.rescaleXMaintainAspectRatio(bufferedImage, this.canvas.getWidth()) : BufferedImageUtils.rescaleYMaintainAspectRatio(bufferedImage, this.canvas.getHeight());
            }
            PImage pImage = new PImage(bufferedImage);
            double d3 = this.floorGraphic.getGlobalFullBounds().getMinY();
            if (this.floorGraphic.getVisible()) {
                Point2D.Double double_ = new Point2D.Double(0.0, d3);
                this.globalToLocal(double_);
                double d4 = pImage.getFullBounds().getHeight() - d3;
                pImage.translate(0.0, -d4);
            }
            this.addChild(pImage);
        }
    }

    public void setBackground(BufferedImage bufferedImage) {
        if (bufferedImage != null) {
            BufferedImage bufferedImage2 = BufferedImageUtils.toBufferedImage(bufferedImage);
            this.canvas.setBackground(new Color(bufferedImage2.getRGB(bufferedImage2.getWidth() / 2, 30)));
        } else {
            this.canvas.setBackground(EnergySkateParkRootNode.SKY_COLOR);
        }
        if (this.backgroundImage != bufferedImage) {
            this.backgroundImage = bufferedImage;
            this.update();
        }
    }
}

