/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.piccolophet.nodes.PieChartNode;
import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.view.EnergyLookAndFeel;
import edu.colorado.phet.energyskatepark.view.piccolo.SkaterNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class EnergySkateParkPieChartNode
extends PNode {
    private final PieChartNode pieChartNode;
    private final AbstractEnergySkateParkModule module;
    private final SkaterNode skaterNode;
    private final double dy = 25.0;
    private boolean ignoreThermal;
    private final Body body;

    public EnergySkateParkPieChartNode(AbstractEnergySkateParkModule abstractEnergySkateParkModule, SkaterNode skaterNode) {
        this.module = abstractEnergySkateParkModule;
        this.skaterNode = skaterNode;
        this.pieChartNode = new PieChartNode(this.createPieValues(), this.createPieRect());
        this.body = skaterNode.getBody();
        this.addChild(this.pieChartNode);
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.body.addListener(new Body.ListenerAdapter(){

            public void positionAngleChanged() {
                EnergySkateParkPieChartNode.this.update();
            }

            public void energyChanged() {
                EnergySkateParkPieChartNode.this.update();
            }
        });
    }

    private Rectangle createPieRect() {
        if (this.getModel().containsBody(this.body)) {
            PBounds pBounds = this.skaterNode.getGlobalFullBounds();
            Point2D.Double double_ = new Point2D.Double(pBounds.getCenterX(), pBounds.getY() - 25.0);
            this.globalToLocal(double_);
            double d = this.getTotalEnergy();
            double d2 = d / 10.0 * 3.5;
            double d3 = Math.sqrt(d2 / Math.PI);
            Rectangle rectangle = new Rectangle();
            rectangle.setFrameFromCenter(((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)double_).getX() + d3, ((Point2D)double_).getY() + d3);
            return rectangle;
        }
        return new Rectangle(10, 10);
    }

    private double getTotalEnergy() {
        if (this.ignoreThermal) {
            return this.body.getKineticEnergy() + Math.abs(this.body.getPotentialEnergy());
        }
        return this.body.getKineticEnergy() + Math.abs(this.body.getPotentialEnergy()) + this.body.getThermalEnergy();
    }

    private EnergySkateParkModel getModel() {
        return this.module.getEnergySkateParkModel();
    }

    private PieChartNode.PieValue[] createPieValues() {
        if (this.module.getEnergySkateParkModel().getNumBodies() > 0) {
            Body body = this.module.getEnergySkateParkModel().getBody(0);
            double d = body.getKineticEnergy();
            double d2 = Math.abs(body.getPotentialEnergy());
            double d3 = body.getThermalEnergy();
            PieChartNode.PieValue[] pieValueArray = new PieChartNode.PieValue[]{new PieChartNode.PieValue(d, this.getLookAndFeel().getKEColor()), d2 > 0.0 ? new PieChartNode.PieValue(d2, this.getLookAndFeel().getPEColor()) : new PieChartNode.PieValue(Math.abs(d2), Color.black), d3 > 0.0 ? new PieChartNode.PieValue(d3, this.getLookAndFeel().getThermalEnergyColor()) : new PieChartNode.PieValue(Math.abs(d3), Color.black)};
            if (this.ignoreThermal) {
                pieValueArray = new PieChartNode.PieValue[]{new PieChartNode.PieValue(d, this.getLookAndFeel().getKEColor()), body.getPotentialEnergy() > 0.0 ? new PieChartNode.PieValue(d2, this.getLookAndFeel().getPEColor()) : new PieChartNode.PieValue(Math.abs(d2), Color.black)};
            }
            return pieValueArray;
        }
        return new PieChartNode.PieValue[0];
    }

    private EnergyLookAndFeel getLookAndFeel() {
        return this.module.getEnergyLookAndFeel();
    }

    private void update() {
        this.pieChartNode.setArea(this.createPieRect());
        this.pieChartNode.setPieValues(this.createPieValues());
        this.setVisible(this.skaterNode.getBody().getPotentialEnergy() >= 0.0);
    }

    public void setIgnoreThermal(boolean bl) {
        this.ignoreThermal = bl;
        this.update();
    }
}

