/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.PopupMenuHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.colorado.phet.common.spline.ParametricFunction2D;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.EnergySkateParkSimSharing;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;
import edu.colorado.phet.energyskatepark.util.EnergySkateParkLogging;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSplineEnvironment;
import edu.colorado.phet.energyskatepark.view.SplineMatch;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SplineNode
extends PNode {
    private final TrackNode splinePath;
    private final PhetPPath rollerCoasterPath;
    private final PNode controlPointLayer;
    private Point2D.Double[] initDragSpline;
    private Point2D.Double controlPointLoc;
    private final BasicStroke dottedStroke = new BasicStroke(0.03f, 2, 0, 1.0f, new float[]{0.09f, 0.09f}, 0.0f);
    private final BasicStroke lineStroke = new BasicStroke(0.03f);
    private EnergySkateParkSpline spline;
    private EnergySkateParkSpline lastState;
    private final PBasicInputEventHandler dragHandler;
    private final JComponent parent;
    private final EnergySkateParkSplineEnvironment splineEnvironment;
    private final TrackNode centerPath;
    private final TrackPopupMenu popupMenu;
    private final EnergySkateParkSpline.Listener splineListener;
    private final boolean isDev = false;

    public SplineNode(JComponent jComponent, EnergySkateParkSpline energySkateParkSpline, EnergySkateParkSplineEnvironment energySkateParkSplineEnvironment, boolean bl) {
        this.parent = jComponent;
        this.splineEnvironment = energySkateParkSplineEnvironment;
        this.spline = energySkateParkSpline;
        this.splinePath = new TrackNode(0.75f, Color.gray);
        this.centerPath = new TrackNode(0.15f, new Color(235, 193, 56));
        this.rollerCoasterPath = new PhetPPath(this.getRailroadStroke(0.4f), (Paint)Color.gray);
        this.rollerCoasterPath.setPickable(false);
        this.rollerCoasterPath.setChildrenPickable(false);
        this.centerPath.setPickable(false);
        this.centerPath.setChildrenPickable(false);
        this.controlPointLayer = new PNode();
        this.addChild(this.splinePath);
        this.addChild(this.centerPath);
        this.addChild(this.rollerCoasterPath);
        if (bl) {
            this.addChild(this.controlPointLayer);
        }
        this.dragHandler = new SimSharingDragHandler(UserComponentChain.chain((IUserComponent)EnergySkateParkSimSharing.UserComponents.track, this.spline.getParametricFunction2D().index), UserComponentTypes.sprite){

            public ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
                return super.getParametersForAllEvents(pInputEvent).with((IParameterKey)EnergySkateParkSimSharing.ParameterKeys.trackIndex, ((SplineNode)SplineNode.this).spline.getParametricFunction2D().index);
            }

            protected void drag(PInputEvent pInputEvent) {
                super.drag(pInputEvent);
                SplineNode.this.dragSpline(pInputEvent);
            }

            protected void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                SplineNode.this.finishDragSpline(pInputEvent);
            }

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                SplineNode.this.initDragSpline();
            }
        };
        this.popupMenu = new TrackPopupMenu(energySkateParkSplineEnvironment);
        if (bl) {
            this.splinePath.addInputEventListener(this.dragHandler);
            this.splinePath.addInputEventListener(new CursorHandler(12));
            this.splinePath.addInputEventListener(new PopupMenuHandler(UserComponentChain.chain((IUserComponent)EnergySkateParkSimSharing.UserComponents.track, this.spline.getParametricFunction2D().index), jComponent, this.popupMenu));
        }
        this.splineListener = new EnergySkateParkSpline.Listener(){

            public void rollerCoasterModeChanged() {
                SplineNode.this.update();
            }

            public void controlPointsChanged() {
                SplineNode.this.update();
            }
        };
        energySkateParkSpline.addListener(this.splineListener);
        this.update();
    }

    private void showColorControls() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        jPanel.add((Component)new TrackEditPanel(this.splinePath, "Outside Line"), gridBagConstraints);
        jPanel.add((Component)new TrackEditPanel(this.centerPath, "Center Line"), gridBagConstraints);
        JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this.parent));
        jDialog.setContentPane(jPanel);
        jDialog.pack();
        SwingUtils.centerDialogInParent(jDialog);
        jDialog.setVisible(true);
    }

    public ParametricFunction2D getParametricFunction2D() {
        return this.spline.getParametricFunction2D();
    }

    private BasicStroke getTrackStroke(float f) {
        return new BasicStroke((float)(0.25 * (double)f));
    }

    private BasicStroke getRailroadStroke(float f) {
        return new BasicStroke((float)(0.25 * (double)f), 0, 0, 1.0f, new float[]{0.1f, 0.15f}, 0.0f);
    }

    private void dragSpline(PInputEvent pInputEvent) {
        Point2D.Double double_ = new Point2D.Double(pInputEvent.getDeltaRelativeTo((PNode)this).width, pInputEvent.getDeltaRelativeTo((PNode)this).height);
        this.dragSpline(pInputEvent, double_);
    }

    private void dragSpline(PInputEvent pInputEvent, Point2D.Double double_) {
        double d = double_.getY();
        double d2 = double_.getX();
        if (d < 0.0 && this.spline.getMinControlPointY() < 0.0 || d > 0.0 && this.spline.getMaxControlPointY() > this.splineEnvironment.getMaxDragY() || d2 < 0.0 && this.spline.getMinControlPointX() < this.splineEnvironment.getMinDragX() || d2 > 0.0 && this.spline.getMaxControlPointX() > this.splineEnvironment.getMaxDragX()) {
            return;
        }
        this.translateAll(double_);
        if (this.isAttachAllowed(pInputEvent)) {
            this.proposeMatchesTrunk();
        }
    }

    public EnergySkateParkSpline getSpline() {
        return this.spline;
    }

    public void detachListeners() {
        this.spline.removeListener(this.splineListener);
        this.popupMenu.detachListeners();
    }

    public void processExternalStartDragEvent() {
        this.initDragSpline();
    }

    public void processExternalDragEvent(PInputEvent pInputEvent, double d, double d2) {
        this.dragSpline(pInputEvent, new Point2D.Double(d, d2));
    }

    public void processExternalDropEvent(PInputEvent pInputEvent) {
        this.finishDragSpline(pInputEvent);
    }

    private void finishDragSpline(PInputEvent pInputEvent) {
        boolean bl;
        if (this.isAttachAllowed(pInputEvent) && !(bl = this.testAttach(0))) {
            this.testAttach(this.numControlPointGraphics() - 1);
        }
        this.initDragSpline = null;
        this.spline.setUserControlled(false);
    }

    private boolean testAttach(int n) {
        SplineMatch splineMatch = this.getTrunkMatch(n);
        if (splineMatch != null) {
            EnergySkateParkSpline energySkateParkSpline = this.attach(n, splineMatch);
            SimSharingManager.sendUserMessage(UserComponentChain.chain((IUserComponent)EnergySkateParkSimSharing.UserComponents.track, this.spline.getParametricFunction2D().index), UserComponentTypes.sprite, EnergySkateParkSimSharing.UserActions.attached, ParameterSet.parameterSet((IParameterKey)EnergySkateParkSimSharing.ParameterKeys.inputTrack1, this.spline.getParametricFunction2D().index).with((IParameterKey)EnergySkateParkSimSharing.ParameterKeys.inputTrack2, splineMatch.getEnergySkateParkSpline().getParametricFunction2D().index).with((IParameterKey)EnergySkateParkSimSharing.ParameterKeys.outputTrack, energySkateParkSpline.getParametricFunction2D().index));
            return true;
        }
        return false;
    }

    private void initDragSpline() {
        this.spline.setUserControlled(true);
        this.initDragSpline = new Point2D.Double[this.spline.getControlPoints().length];
        for (int i = 0; i < this.initDragSpline.length; ++i) {
            this.initDragSpline[i] = new Point2D.Double(this.spline.getControlPoint(i).getX(), this.spline.getControlPoint(i).getY());
        }
    }

    private void proposeMatchesTrunk() {
        boolean bl = this.proposeMatchTrunk(0);
        if (!bl) {
            this.proposeMatchTrunk(this.numControlPointGraphics() - 1);
        }
    }

    private boolean proposeMatchTrunk(int n) {
        SplineMatch splineMatch = this.getTrunkMatch(n);
        if (splineMatch != null) {
            this.spline.setControlPointLocation(n, new SerializablePoint2D(splineMatch.getTarget().getFullBounds().getCenter2D()));
            return true;
        }
        this.spline.setControlPointLocation(n, new SerializablePoint2D(this.initDragSpline[n]));
        return false;
    }

    private SplineMatch getTrunkMatch(int n) {
        if (this.initDragSpline == null) {
            EnergySkateParkLogging.println("initdragspline was null");
            return null;
        }
        if (n < 0 || n > this.initDragSpline.length) {
            EnergySkateParkLogging.println("index = " + n + ", initDragSpline.length=" + this.initDragSpline.length);
            return null;
        }
        Point2D.Double double_ = new Point2D.Double(this.initDragSpline[n].getX(), this.initDragSpline[n].getY());
        return this.splineEnvironment.proposeMatch(this, double_);
    }

    private void translateAll(Point2D point2D) {
        this.translateAll(point2D.getX(), point2D.getY());
    }

    private void translateAll(double d, double d2) {
        this.spline.translate(d, d2);
        for (int i = 0; i < this.initDragSpline.length; ++i) {
            this.initDragSpline[i].x += d;
            this.initDragSpline[i].y += d2;
        }
    }

    private void update() {
        this.setPickable(this.spline.isInteractive());
        this.setChildrenPickable(this.spline.isInteractive());
        if (this.changed()) {
            Cloneable cloneable;
            int n;
            GeneralPath generalPath = this.spline.getInterpolationPath();
            this.splinePath.setPathTo(generalPath);
            this.centerPath.setPathTo(generalPath);
            this.rollerCoasterPath.setPathTo(generalPath);
            this.rollerCoasterPath.setVisible(this.spline.isRollerCoasterMode());
            this.rollerCoasterPath.setStrokePaint(this.spline.isRollerCoasterMode() ? Color.gray : Color.black);
            this.controlPointLayer.removeAllChildren();
            for (n = 0; n < this.spline.numControlPoints(); ++n) {
                cloneable = this.spline.getControlPoint(n);
                this.addControlPoint((Point2D)cloneable, n);
            }
            for (n = 0; n < this.controlPointLayer.getChildrenCount(); ++n) {
                cloneable = (PPath)this.controlPointLayer.getChild(n);
                if (n == 0 || n == this.controlPointLayer.getChildrenCount() - 1) {
                    ((PPath)cloneable).setStroke(this.dottedStroke);
                    ((PPath)cloneable).setStrokePaint(PhetColorScheme.RED_COLORBLIND);
                    continue;
                }
                ((PPath)cloneable).setStroke(this.lineStroke);
                ((PPath)cloneable).setStrokePaint(Color.black);
            }
            this.lastState = this.spline.copy();
        }
        this.popupMenu.updateAll();
    }

    private boolean changed() {
        return this.lastState == null || !this.same();
    }

    private boolean same() {
        return this.lastState.equals(this.spline.copy());
    }

    public boolean isAttachAllowed(PInputEvent pInputEvent) {
        return !pInputEvent.isControlDown();
    }

    private void addControlPoint(Point2D point2D, int n) {
        this.controlPointLayer.addChild(new ControlPointNode(point2D.getX(), point2D.getY(), 0.5, n));
    }

    private void proposeMatchesEndpoint(int n) {
        if (n == 0 || n == this.numControlPointGraphics() - 1) {
            SplineMatch splineMatch = this.getEndpointMatch();
            EnergySkateParkLogging.println("match=" + splineMatch);
            if (splineMatch != null) {
                this.spline.setControlPointLocation(n, new SerializablePoint2D(splineMatch.getTarget().getFullBounds().getCenter2D()));
            } else {
                this.spline.setControlPointLocation(n, new SerializablePoint2D(this.controlPointLoc));
            }
        }
    }

    private SplineMatch getEndpointMatch() {
        Point2D.Double double_ = new Point2D.Double(this.controlPointLoc.getX(), this.controlPointLoc.getY());
        return this.splineEnvironment.proposeMatch(this, double_);
    }

    private void finishDragControlPoint(int n) {
        if (n == 0 || n == this.numControlPointGraphics() - 1) {
            SplineMatch splineMatch = this.getEndpointMatch();
            if (splineMatch != null) {
                this.attach(n, splineMatch);
            }
            this.controlPointLoc = null;
        }
    }

    private EnergySkateParkSpline attach(int n, SplineMatch splineMatch) {
        return this.splineEnvironment.attach(this, n, splineMatch);
    }

    private void initDragControlPoint(int n) {
        if (n == 0 || n == this.numControlPointGraphics() - 1) {
            this.controlPointLoc = new Point2D.Double(this.spline.getControlPoint(n).getX(), this.spline.getControlPoint(n).getY());
        }
    }

    public PNode getControlPointGraphic(int n) {
        return this.controlPointLayer.getChild(n);
    }

    public int numControlPointGraphics() {
        return this.controlPointLayer.getChildrenCount();
    }

    public void setControlPointsPickable(boolean bl) {
        this.controlPointLayer.setPickable(bl);
        this.controlPointLayer.setChildrenPickable(bl);
        for (int i = 0; i < this.numControlPointGraphics(); ++i) {
            this.getControlPointGraphic(i).setPickable(bl);
            this.getControlPointGraphic(i).setChildrenPickable(bl);
        }
        this.update();
    }

    class ControlCirclePopupMenu
    extends JPopupMenu {
        public ControlCirclePopupMenu(final int n) {
            JMenuItem jMenuItem = new JMenuItem(EnergySkateParkResources.getString("controls.delete-point"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SplineNode.this.spline.numControlPoints() <= 2) {
                        SplineNode.this.splineEnvironment.removeSpline(SplineNode.this);
                        SplineNode.this.splineEnvironment.notifySplineDeletedByUser();
                    } else {
                        SplineNode.this.spline.removeControlPoint(n);
                    }
                }
            });
            this.add(jMenuItem);
        }
    }

    private class ControlPointNode
    extends PPath {
        public ControlPointNode(double d, double d2, double d3, final int n) {
            super(new Ellipse2D.Double(d - d3 / 2.0, d2 - d3 / 2.0, d3, d3));
            this.setStroke(SplineNode.this.dottedStroke);
            this.setStrokePaint(Color.black);
            this.setPaint(new Color(0.0f, 0.0f, 1.0f, 0.5f));
            UserComponentChain userComponentChain = UserComponentChain.chain(EnergySkateParkSimSharing.UserComponents.track, new UserComponent(((SplineNode)SplineNode.this).spline.getParametricFunction2D().index), EnergySkateParkSimSharing.UserComponents.controlPoint, new UserComponent(n));
            this.addInputEventListener(new SimSharingDragHandler(userComponentChain, UserComponentTypes.sprite){

                protected void startDrag(PInputEvent pInputEvent) {
                    super.startDrag(pInputEvent);
                    SplineNode.this.initDragControlPoint(n);
                    SplineNode.this.spline.setUserControlled(true);
                    pInputEvent.setHandled(true);
                }

                public ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
                    return super.getParametersForAllEvents(pInputEvent).with((IParameterKey)EnergySkateParkSimSharing.ParameterKeys.trackIndex, ((SplineNode)SplineNode.this).spline.getParametricFunction2D().index);
                }

                protected void drag(PInputEvent pInputEvent) {
                    super.drag(pInputEvent);
                    PDimension pDimension = pInputEvent.getDeltaRelativeTo(SplineNode.this);
                    if (SplineNode.this.spline.getControlPoints()[n].getY() + pDimension.getHeight() < SplineNode.this.splineEnvironment.getMinDragY()) {
                        pDimension.height = SplineNode.this.splineEnvironment.getMinDragY() - SplineNode.this.spline.getControlPoints()[n].getY();
                    }
                    if (SplineNode.this.spline.getControlPoints()[n].getY() + pDimension.getHeight() > SplineNode.this.splineEnvironment.getMaxDragY()) {
                        pDimension.height = SplineNode.this.splineEnvironment.getMaxDragY() - SplineNode.this.spline.getControlPoints()[n].getY();
                    }
                    if (SplineNode.this.spline.getControlPoints()[n].getX() + pDimension.getWidth() < SplineNode.this.splineEnvironment.getMinDragX()) {
                        pDimension.width = SplineNode.this.splineEnvironment.getMinDragX() - SplineNode.this.spline.getControlPoints()[n].getX();
                    }
                    if (SplineNode.this.spline.getControlPoints()[n].getX() + pDimension.getWidth() > SplineNode.this.splineEnvironment.getMaxDragX()) {
                        pDimension.width = SplineNode.this.splineEnvironment.getMaxDragX() - SplineNode.this.spline.getControlPoints()[n].getX();
                    }
                    SplineNode.this.spline.translateControlPoint(n, pDimension.getWidth(), pDimension.getHeight());
                    if (n == 0 || n == SplineNode.this.numControlPointGraphics() - 1) {
                        ((SplineNode)SplineNode.this).controlPointLoc.x += pDimension.getWidth();
                        ((SplineNode)SplineNode.this).controlPointLoc.y += pDimension.getHeight();
                    }
                    if (SplineNode.this.isAttachAllowed(pInputEvent)) {
                        SplineNode.this.proposeMatchesEndpoint(n);
                    }
                    pInputEvent.setHandled(true);
                }

                protected void endDrag(PInputEvent pInputEvent) {
                    super.endDrag(pInputEvent);
                    if (SplineNode.this.isAttachAllowed(pInputEvent)) {
                        SplineNode.this.finishDragControlPoint(n);
                    }
                    SplineNode.this.spline.setUserControlled(false);
                    pInputEvent.setHandled(true);
                }
            });
            this.addInputEventListener(new CursorHandler(12));
            this.addInputEventListener(new PopupMenuHandler(userComponentChain, SplineNode.this.parent, new ControlCirclePopupMenu(n)));
        }
    }

    class TrackEditPanel
    extends JPanel {
        public TrackEditPanel(final TrackNode trackNode, String string) {
            final ModelSlider modelSlider = new ModelSlider(string, "", 0.0, 10.0, trackNode.getThickness());
            modelSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    trackNode.setThickness((float)modelSlider.getValue());
                }
            });
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 0;
            final JColorChooser jColorChooser = new JColorChooser(trackNode.getColor());
            jColorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    trackNode.setColor(jColorChooser.getColor());
                }
            });
            this.add((Component)modelSlider, gridBagConstraints);
            this.add((Component)jColorChooser, gridBagConstraints);
        }
    }

    class TrackNode
    extends PhetPPath {
        private float thickness;
        private Color color;

        public TrackNode(float f, Color color) {
            super(SplineNode.this.getTrackStroke(f), (Paint)color);
            this.thickness = f;
            this.color = color;
        }

        public float getThickness() {
            return this.thickness;
        }

        public void setThickness(float f) {
            this.thickness = f;
            this.setStroke(SplineNode.this.getTrackStroke(f));
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
            this.setStrokePaint(color);
        }
    }

    class TrackPopupMenu
    extends JPopupMenu {
        private final JCheckBoxMenuItem rollerCoasterMode;
        private final EnergySkateParkSpline.Listener splineListener = new EnergySkateParkSpline.Listener(){

            public void rollerCoasterModeChanged() {
                TrackPopupMenu.this.updateAll();
            }

            public void controlPointsChanged() {
            }
        };

        public TrackPopupMenu(final EnergySkateParkSplineEnvironment energySkateParkSplineEnvironment) {
            this.rollerCoasterMode = new JCheckBoxMenuItem(EnergySkateParkResources.getString("track.roller-coaster-mode"), SplineNode.this.spline.isRollerCoasterMode());
            this.attachListeners(SplineNode.this.spline);
            this.rollerCoasterMode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    energySkateParkSplineEnvironment.setRollerCoasterMode(TrackPopupMenu.this.rollerCoasterMode.isSelected());
                    SplineNode.this.spline.setRollerCoasterMode(TrackPopupMenu.this.rollerCoasterMode.isSelected());
                    SplineNode.this.lastState = null;
                }
            });
            JMenuItem jMenuItem = new JMenuItem(EnergySkateParkResources.getString("controls.delete-track"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    energySkateParkSplineEnvironment.removeSpline(SplineNode.this);
                    energySkateParkSplineEnvironment.notifySplineDeletedByUser();
                }
            });
            JMenuItem jMenuItem2 = new JMenuItem("Edit Look");
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SplineNode.this.showColorControls();
                }
            });
            this.add(this.rollerCoasterMode);
            this.addSeparator();
            this.add(jMenuItem);
        }

        public void detachListeners() {
            SplineNode.this.spline.removeListener(this.splineListener);
        }

        private void updateAll() {
            this.rollerCoasterMode.setSelected(SplineNode.this.spline.isRollerCoasterMode());
        }

        public void attachListeners(EnergySkateParkSpline energySkateParkSpline) {
            energySkateParkSpline.addListener(this.splineListener);
        }
    }
}

