/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.util.EnergySkateParkLogging;
import edu.colorado.phet.energyskatepark.view.SkaterCharacter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class ChooseCharacterDialog
extends PaintImmediateDialog {
    private final JPanel contentPanel = new JPanel(new GridBagLayout());
    private final GridBagConstraints gridBagConstraints = new GridBagConstraints();
    private final ArrayList characterPanels = new ArrayList();
    private final AbstractEnergySkateParkModule module;

    public ChooseCharacterDialog(AbstractEnergySkateParkModule abstractEnergySkateParkModule) {
        super(abstractEnergySkateParkModule.getPhetFrame(), EnergySkateParkResources.getString("controls.choose-character"), false);
        int n;
        this.module = abstractEnergySkateParkModule;
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = -1;
        this.setContentPane(this.contentPanel);
        JButton jButton = new JButton(PhetCommonResources.getString("Common.choice.ok"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChooseCharacterDialog.this.dispose();
            }
        });
        SkaterCharacter[] skaterCharacterArray = abstractEnergySkateParkModule.getSkaterCharacters();
        CharacterPanel[] characterPanelArray = new CharacterPanel[skaterCharacterArray.length];
        for (int i = 0; i < skaterCharacterArray.length; ++i) {
            characterPanelArray[i] = new CharacterPanel(abstractEnergySkateParkModule, skaterCharacterArray[i]);
        }
        Dimension dimension = new Dimension(0, 0);
        for (n = 0; n < characterPanelArray.length; ++n) {
            dimension.width = Math.max(dimension.width, characterPanelArray[n].getPreferredSize().width);
            dimension.height = Math.max(dimension.height, characterPanelArray[n].getPreferredSize().height);
        }
        for (n = 0; n < skaterCharacterArray.length; ++n) {
            characterPanelArray[n].setPreferredSize(dimension);
            this.addCharacterPanel(characterPanelArray[n]);
        }
        this.contentPanel.add((Component)jButton, this.gridBagConstraints);
        this.pack();
        SwingUtils.centerDialogInParent(this);
    }

    private void addCharacterPanel(final CharacterPanel characterPanel) {
        this.contentPanel.add((Component)characterPanel, this.gridBagConstraints);
        characterPanel.addMouseListener(new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                EnergySkateParkLogging.println("e = " + mouseEvent);
                ChooseCharacterDialog.this.setSelection(characterPanel);
            }
        });
        characterPanel.setSelected(characterPanel.getSkaterCharacter() == this.module.getSkaterCharacter());
        this.characterPanels.add(characterPanel);
    }

    private void setSelection(CharacterPanel characterPanel) {
        for (int i = 0; i < this.characterPanels.size(); ++i) {
            CharacterPanel characterPanel2;
            characterPanel2.setSelected((characterPanel2 = (CharacterPanel)this.characterPanels.get(i)) == characterPanel);
        }
        this.pack();
    }

    static class CharacterPanel
    extends JPanel {
        private boolean selected = false;
        private final AbstractEnergySkateParkModule module;
        private final SkaterCharacter skaterCharacter;

        public CharacterPanel(AbstractEnergySkateParkModule abstractEnergySkateParkModule, SkaterCharacter skaterCharacter) {
            super(new GridBagLayout());
            this.module = abstractEnergySkateParkModule;
            this.skaterCharacter = skaterCharacter;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            String string = EnergySkateParkResources.getString("controls.choose-character.label.pattern");
            String string2 = MessageFormat.format(string, skaterCharacter.getName(), skaterCharacter.getMass(), EnergySkateParkResources.getString("units.kg"));
            JLabel jLabel = new JLabel(string2, new ImageIcon(BufferedImageUtils.rescaleYMaintainAspectRatio(skaterCharacter.getImage(), (int)(skaterCharacter.getModelHeight() * 75.0))), 11);
            this.add((Component)jLabel, gridBagConstraints);
            this.setSelected(false);
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            this.setBorder(bl ? this.getSelectionBorder() : BorderFactory.createEtchedBorder());
            if (bl) {
                this.module.setSkaterCharacter(this.skaterCharacter);
            }
        }

        private Border getSelectionBorder() {
            return BorderFactory.createLineBorder(Color.blue, 3);
        }

        public SkaterCharacter getSkaterCharacter() {
            return this.skaterCharacter;
        }
    }
}

