/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.model.Planet;
import edu.colorado.phet.energyskatepark.view.swing.GravitySlider;
import edu.colorado.phet.energyskatepark.view.swing.PlanetButton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class LocationControlPanel
extends VerticalLayoutPanel {
    private final JCheckBox showBackgroundCheckbox;
    private final PlanetButton[] planetButtons;
    private final AbstractEnergySkateParkModule module;
    private final PlanetButtonLayout layout;

    public LocationControlPanel(AbstractEnergySkateParkModule abstractEnergySkateParkModule, PlanetButtonLayout planetButtonLayout, boolean bl) {
        this.layout = planetButtonLayout;
        this.module = abstractEnergySkateParkModule;
        Planet[] planetArray = abstractEnergySkateParkModule.getPlanets();
        this.planetButtons = new PlanetButton[planetArray.length];
        for (int i = 0; i < planetArray.length; ++i) {
            this.planetButtons[i] = new PlanetButton(abstractEnergySkateParkModule, planetArray[i], planetArray[i].isDefault());
        }
        this.setBorder(BorderFactory.createTitledBorder(EnergySkateParkResources.getString("location")));
        this.setFillHorizontal();
        this.showBackgroundCheckbox = new JCheckBox(EnergySkateParkResources.getString("controls.show-background"), true);
        JPanel jPanel = planetButtonLayout.getPlanetPanel(this.planetButtons);
        this.setAnchor(17);
        if (!bl) {
            this.setFillNone();
        }
        this.add(jPanel);
        GravitySlider gravitySlider = new GravitySlider(abstractEnergySkateParkModule);
        this.addFullWidth(gravitySlider);
        abstractEnergySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void gravityChanged() {
                LocationControlPanel.this.synchronizePlanet();
            }

            public void stateSet() {
                LocationControlPanel.this.synchronizePlanet();
            }
        });
        this.showBackgroundCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LocationControlPanel.this.synchronizePlanet();
            }
        });
        this.synchronizePlanet();
        new Planet.Earth().apply(abstractEnergySkateParkModule);
    }

    public void reset() {
        this.showBackgroundCheckbox.setSelected(true);
        this.synchronizePlanet();
    }

    private void synchronizePlanet() {
        this.module.getEnergySkateParkSimulationPanel().getRootNode().setBackgroundVisible(this.showBackgroundCheckbox.isSelected());
        boolean bl = false;
        for (int i = 0; i < this.planetButtons.length; ++i) {
            Planet planet = this.planetButtons[i].getPlanet();
            if (this.module.getEnergySkateParkModel().getGravity() == planet.getGravity()) {
                planet.apply(this.module);
                bl = true;
            }
            boolean bl2 = this.module.getEnergySkateParkModel().getGravity() == planet.getGravity();
            this.planetButtons[i].setSelected(bl2);
        }
        if (!bl) {
            this.module.getEnergySkateParkSimulationPanel().getRootNode().clearBackground();
        }
    }

    public static interface PlanetButtonLayout {
        public JPanel getPlanetPanel(PlanetButton[] var1);
    }

    public static class TwoColumnLayout
    implements PlanetButtonLayout {
        public JPanel getPlanetPanel(PlanetButton[] planetButtonArray) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.add(jPanel, planetButtonArray[0], gridBagConstraints, 0, 0);
            this.add(jPanel, planetButtonArray[1], gridBagConstraints, 1, 0);
            this.add(jPanel, planetButtonArray[2], gridBagConstraints, 0, 1);
            this.add(jPanel, planetButtonArray[3], gridBagConstraints, 1, 1);
            return jPanel;
        }

        private void add(JPanel jPanel, PlanetButton planetButton, GridBagConstraints gridBagConstraints, int n, int n2) {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            jPanel.add((Component)planetButton, gridBagConstraints);
        }
    }
}

