/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class PanZoomControl
extends JPanel {
    private final EnergySkateParkSimulationPanel energySkateParkSimulationPanel;
    private final double zoomScale = 1.1;
    private int zoomOutCount = 0;
    private JButton zoomIn;
    private JButton zoomOut;

    public PanZoomControl(EnergySkateParkSimulationPanel energySkateParkSimulationPanel) {
        this.energySkateParkSimulationPanel = energySkateParkSimulationPanel;
        this.setLayout(new BoxLayout(this, 1));
        this.zoomOut = new JButton(new ImageIcon(EnergySkateParkResources.getImage("icons/glass-20-minus.gif")));
        this.zoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanZoomControl.this.zoomOutOnce();
            }
        });
        this.add(this.zoomOut);
        this.zoomIn = new JButton(new ImageIcon(EnergySkateParkResources.getImage("icons/glass-20-plus.gif")));
        this.zoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanZoomControl.this.zoomInOnce();
            }
        });
        this.add(this.zoomIn);
        this.zoomIn.setEnabled(false);
        this.setOpaque(false);
    }

    private void zoomInOnce() {
        --this.zoomOutCount;
        this.zoom(1.1);
    }

    private void zoomOutOnce() {
        ++this.zoomOutCount;
        this.zoom(0.9090909090909091);
    }

    private void zoom(double d) {
        double d2 = this.getScreenFractionToGround();
        Point2D point2D = this.energySkateParkSimulationPanel.getCamera().getBounds().getCenter2D();
        this.energySkateParkSimulationPanel.getCamera().localToGlobal(point2D);
        this.energySkateParkSimulationPanel.getPhetRootNode().globalToWorld(point2D);
        this.energySkateParkSimulationPanel.getPhetRootNode().scaleWorldAboutPoint(d, point2D);
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        this.energySkateParkSimulationPanel.getPhetRootNode().worldToScreen(double_);
        double d3 = (double)this.energySkateParkSimulationPanel.getHeight() * (1.0 - d2);
        double d4 = ((Point2D)double_).getY() - d3;
        this.translateWorld(d4);
        this.energySkateParkSimulationPanel.fireZoomEvent();
        this.zoomIn.setEnabled(this.zoomOutCount > 0);
    }

    private void translateWorld(double d) {
        PDimension pDimension = new PDimension(0.0, d);
        this.energySkateParkSimulationPanel.getPhetRootNode().screenToWorld(pDimension);
        this.energySkateParkSimulationPanel.getPhetRootNode().translateWorld(pDimension.width, -pDimension.height);
    }

    private double getScreenFractionToGround() {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        this.energySkateParkSimulationPanel.getPhetRootNode().worldToScreen(double_);
        return 1.0 - ((Point2D)double_).getY() / (double)this.energySkateParkSimulationPanel.getHeight();
    }

    public void reset() {
        while (this.zoomOutCount > 0) {
            this.zoomInOnce();
        }
    }

    public void updateScale() {
        for (int i = 0; i < this.zoomOutCount; ++i) {
            this.zoom(0.9090909090909091);
        }
    }
}

